// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "mpilib.h"

extern	BYTE	Temp1;
extern	BYTE	Temp2;
extern	BYTE	Temp3;
extern	BYTE	Temp4;
extern	BYTE	Temp5;
extern	BYTE	Temp6;
extern	BYTE	Temp9;
extern	BYTE	ASN_SEQ;
extern	BYTE	SHA1_SEQ;
extern	BYTE	SHA512_SEQ;
extern	DWORD	dwCountBytes;
extern	DWORD	dwCountDwords;
extern	BOOL	bCancelOperation;
extern	LPBYTE	pRandBitsBin;
extern	HANDLE	hRBBThread;
extern	HANDLE	hDCTThread;
extern	BOOL	bUseMd5;

// RsaPubDec decrypts a block of data equal to the size of modulus n
// using your public key. EXP_E and Modulus n must not be destroyed.
// Checking only needs to de done for signatures on the various sizes
// of the variables. This is done before the function is entered.
//
// We only support the new message digest packet format for PGP 2.3
// and later.
//
// Uses: Temp5
//
// Returns: Decrypted data in OutBuff. dwCountBytes = byte count
//          of data. Returns TRUE is we have an error, else FALSE.
//...................................................................
BOOL RsaPubDec(LPBYTE lpOutBuff, LPBYTE lpInBuff, LPBYTE lpExpE, LPBYTE lpModN, 
			   DWORD dwModNBytes)
{
	BOOL	bError = FALSE;
	LPBYTE	lpTemp;
	int		iResult;

	dwCountBytes = 0;

	SuspendThread(hRBBThread);
	SuspendThread(hDCTThread);
	set_precision(bytes2units(dwModNBytes+SLOP_BYTES));
	iResult = mp_modexp((unitptr)&Temp5,(unitptr)lpInBuff,(unitptr)lpExpE,(unitptr)lpModN);
	ResumeThread(hDCTThread);
	ResumeThread(hRBBThread);

	if (iResult < 0)
	{
		goto PubDecEnd;
	}
	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto PubDecEnd;
	}

	CircleSwap(&Temp5,dwModNBytes);

	__asm
	{
		mov		edi,offset Temp5
		xor		ecx,ecx
		cmp		byte ptr [edi],0
		je		L1
		mov		bError,TRUE
		jmp		PubDecEnd
	L1:	cmp		byte ptr [edi+1],MD_ENCRYPTED
		je		L2
		cmp		byte ptr [edi+1],SHA_ENCRYPTED
		je		L2
		cmp		byte ptr [edi+1],SHA512_ENCRYPTED
		je		L2
		mov		bError,TRUE
		jmp		PubDecEnd
	L2:	add		edi,2

		// We have to get beyond our FF padding. The first byte
		// after the padding is a 0.
		//.....................................................
		mov		al,-1
		mov		ecx,MAX_MOD_BYTES
		repe	scasb

		// If the preceeding byte is not a 0 we have an error.
		//....................................................
		xor		ecx,ecx
		cmp		byte ptr [edi-1],0
		je		L3
		mov		bError,TRUE
		jmp		PubDecEnd

		// Now check for the ASN sequence.
		//................................
	L3:	push	edi
		mov		esi,offset ASN_SEQ
		mov		ecx,ASN_LENGTH
		repe	cmpsb
		je		L4
		
		// No ASN sequence. Check for Sha1 sequence.
		//..........................................
		pop		edi
		push	edi
		mov		esi,offset SHA1_SEQ
		mov		ecx,SHA1_LENGTH
		repe	cmpsb
		je		L4

		// No Sha1 sequence. Check for Sha512 sequence.
		//.............................................
		pop		edi
		push	edi
		mov		esi,offset SHA512_SEQ
		mov		ecx,SHA512_LENGTH
		repe	cMpsb
		je		L4
		pop		ecx
		mov		bError,TRUE
		jmp		PubDecEnd

		// The number of bytes we need to transfer back is equal
		// to Mod n bytes minus (edi minus the offset of Temp5).
		//......................................................
	L4:	pop		ecx						// Get rid of edi on stack.
		mov		edx,edi
		sub		edx,offset Temp5
		mov		ecx,dwModNBytes
		sub		ecx,edx
		mov		dwCountBytes,ecx
		mov		lpTemp,edi
	}
	if (dwCountBytes < MAX_MOD_BYTES)
	{
		CopyMemory(lpOutBuff,lpTemp,dwCountBytes);
	}

	PubDecEnd:

	return(bError);
}

// RsaPubEnc encrypts a block of data equal to the size of Modulus
// n using your public key.
//
// We only support the new conventional DEK packet format
// in PGP 2.3 and later.
//
// Uses: Temp5, and Temp9.
//
// OutBuff must be MAX_MOD_SLOP in length.
//
// Returns: Encrypted block in OutBuff. Bit, byte and dword
//          counts in their respective places.
//................................................................
VOID RsaPubEnc(LPBYTE lpOutBuff, LPBYTE lpInBuff, DWORD dwInBytes, LPBYTE lpExpE,
			   LPBYTE lpModN, DWORD dwModNBytes)
{
	DWORD	dwPadBytes;

	// Clear all the variables we are going to be working with.
	//.........................................................
	ClearEncVariables();

	// Now we have to build the number array we are going to encrypt
	// in Temp9. It will take the form of the following:
	//
	// MSB                                LSB
	//
	// 0   2  Random Padding(n bytes) 0  F  DEK(n bytes) CSUM
	//
	// The random nozero padding adds enough bytes to make the whole
	// string equal in length to the number of bytes in the modulus.
	// Before encrypting it has to be circle swapped so the length
	// will then be equal to the size of the modulus minus 1.
	//..............................................................

	// Calculate the number of random padding bytes needed.
	//.....................................................
	__asm
	{
		mov		eax,dwModNBytes
		sub		eax,4

		// dwInBytes includes the 2 bytes in the checksum.
		//................................................
		sub		eax,dwInBytes
		mov		dwPadBytes,eax

		// Build the string we are going to encrypt. Since the
		// first byte is already 0 we can skip it.
		//....................................................
		mov		edi,offset Temp9
		inc		edi
		mov		al,CK_ENCRYPTED
		stosb

		// Copy in the non zero random data we are going to need.
		// Random data in random bits bin. The most we will need
		// is less than 2,048 bytes. Make sure we do not overrun
		// the end of the random bits bin.
		//......................................................
		mov		esi,pRandBitsBin
		mov		edx,esi
		add		edx,RBB_LENGTH
		mov		ecx,dwPadBytes
	L1:	cmp		esi,edx
		jb		L2
		mov		esi,pRandBitsBin
	L2: lodsb
		cmp		al,0h
		je		L1
		stosb
		dec		ecx
		jnz		L1

		// Put in a framing byte of 0.
		//............................
		mov		al,0h
		stosb

		// Put in the OTP_ALGORITHM byte.
		//...............................
		mov		al,OTP_ALGORITHM
		stosb

		// Now copy in the user data which includes the checksum.
		//.......................................................
		mov		esi,lpInBuff
		mov		ecx,dwInBytes
		rep		movsb
	}
	// Convert to little-endian order for the encryption. This
	// makes the length equal to modulus n-1 bytes. Could only
	// be 1 bit smaller.
	//........................................................
	CircleSwap(&Temp9,dwModNBytes);

	// Encrypt the data using MpModExpDW.
	//...................................
	SuspendThread(hRBBThread);
	SuspendThread(hDCTThread);
	set_precision(bytes2units(dwModNBytes+SLOP_BYTES));
	mp_modexp((unitptr)lpOutBuff,(unitptr)&Temp9,(unitptr)lpExpE,(unitptr)lpModN);
	CountBBD(lpOutBuff,MAX_MOD_SLOP);
	ResumeThread(hDCTThread);
	ResumeThread(hRBBThread);
}

// Clear the encryption variables from Temp1 through Temp9.
// Use by RsaPubEnc and RsaPriEnc.
//.........................................................
VOID ClearEncVariables()
{
	ZeroMemory(&Temp1,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp2,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp3,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp4,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp5,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp6,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp9,MAX_MOD_SLOP);
}

// Clear variables for decryption.
//................................
VOID ClearDecryptVariables()
{
	ZeroMemory(&Temp2,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp3,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp4,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp5,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp6,(MAX_MOD_SLOP*2));
	ZeroMemory(&Temp9,MAX_MOD_SLOP);
}

// RsaPriEnc encrypts a block of data equal to the size of Modulus n
// using your secret key. Anyone with your public key can decrypt the
// data. Exp e and Mod n not required because we use ModExpCrt. Since
// this procedure is only used internally checking for proper size
// of the variables in not done.
//
// We only support the new message digest packet format in PGP 2.3
// and later.
//
// Uses: Temp9, and uses Temp1 for OutBuff.
//       OutBuff must be MAX_MOD_SLOP in length.
//
// lpPPrime, lpQPrime, lpDExp, and lpInvU must not be destroyed.
//
// Returns: Encrypted block in OutBuff. Bit, byte, and dword
//          counts returned in their respective variables.
//...................................................................
BOOL RsaPriEnc(LPBYTE lpOutBuff, LPBYTE lpInBuff, DWORD dwInBytes, LPBYTE lpDExp, 
			   LPBYTE lpPPrime, LPBYTE lpQPrime, LPBYTE lpInvU, DWORD dwModNBytes)
{
	DWORD	dwPadBytes;
	int		iResult = -15;
	BOOL	bUseSha512 = FALSE;
	unit	DP[MAX_UNIT_PRECISION]; 
	unit	DQ[MAX_UNIT_PRECISION];
	unit	temp[MAX_UNIT_PRECISION];

	// Check to see if we should use SHA512 or not.
	//.............................................
	if (dwModNBytes > SHA512_MIN_KEY_SIZE)
	{
		bUseSha512 = TRUE;
	}
	// Clear the variables we are going to be using.
	//..............................................
	ClearEncVariables();

	SuspendThread(hRBBThread);
	SuspendThread(hDCTThread);

	set_precision(bytes2units(dwModNBytes+SLOP_BYTES));

	// Since we do not store these coefficents we have to compute
	// them here. DP = EXP d mod (p-1) and DQ = EXP d mod (q-1).
	//...........................................................
	mp_move(temp,(unitptr)lpPPrime);
	mp_dec(temp);
	mp_mod(DP,(unitptr)lpDExp,temp);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto RsaEnd;
	}

	mp_move(temp,(unitptr)lpQPrime);
	mp_dec(temp);
	mp_mod(DQ,(unitptr)lpDExp,temp);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto RsaEnd;
	}

	// Now we have to build the number array we are going to encrypt
	// in Temp9. It will take the form of the following:
	//
	// MSB                              LSB
	//
	//  0   1   FF(n bytes)   0    ASN(18 bytes)  MD(16 bytes)
	//  0   2   FF(n bytes)   0    SHA1(15 bytes)  SHA1(20 bytes)
	//  0   3   FF(n bytes0   0    SHA512(19 bytes) SHA512(64 bytes)
	//
	// The FF padding adds enough bytes to make the whole string
	// equal in length to the number of bytes in the modulus.
	// Before encrypting it has to be circle swapped so the length
	// will then be equal to the size of the modulus minus 1.
	//..............................................................

	// Calculate the number of FF padding bytes needed.
	//.................................................
	__asm
	{
		mov		eax,dwModNBytes
		cmp		bUseMd5,0
		jz		A1
		sub		eax,(ASN_LENGTH+3)
		jmp		L2

		// Are we using SHA1 or SHA512?
		//.............................
	A1:	cmp		bUseSha512,0
		jz		L1
		sub		eax,(SHA512_LENGTH+3)
		jmp		L2
	L1:	sub		eax,(SHA1_LENGTH+3)
	L2:	mov		ecx,dwInBytes
		sub		eax,ecx
		mov		dwPadBytes,eax

		// Build the string we are going to encrypt. Since the
		// first byte is already 0 we can skip it.
		//....................................................
		mov		edi,offset Temp9
		inc		edi

		// Put in Sha1, Sha512, or Md5 encrypted.
		//.......................................
		mov		al,SHA_ENCRYPTED
		cmp		bUseSha512,0
		jz		A2
		mov		al,SHA512_ENCRYPTED
	A2:	cmp		bUseMd5,0
		jz		L3
		mov		al,MD_ENCRYPTED
	L3: stosb
		mov		al,-1
		mov		ecx,dwPadBytes
		rep		stosb
		mov		al,0
		stosb

		cmp		bUseMd5,1
		je		L4

		// Add the Sha1 or Sha512 sequence.
		//.................................
		cmp		bUseSha512,0
		je		A3

		// Add the Sha512 sequence.
		//.........................
		mov		esi,offset SHA512_SEQ
		mov		ecx,SHA512_LENGTH
		rep		movsb
		jmp		L5

		// Add the Sha1 sequence.
		//.......................
	A3:	mov		esi,offset SHA1_SEQ
		mov		ecx,SHA1_LENGTH
		rep		movsb
		jmp		L5

		// Add the ASN sequence.
		//......................
	L4:	mov		esi,offset ASN_SEQ
		mov		ecx,ASN_LENGTH
		rep		movsb

		// Now copy in the user data.
		//...........................
	L5:	mov		esi,lpInBuff
		mov		ecx,dwInBytes
		rep		movsb
	}
	// Convert to little-endian order for encryption. This
	// makes the length equal to Modulus n -1 bytes. Could
	// be only 1 bit smaller.
	//....................................................
	CircleSwap(&Temp9,dwModNBytes);

	// Encrypt the data using MpModExpCrt.
	//....................................
	iResult = mp_modexp_crt((unitptr)lpOutBuff,(unitptr)&Temp9,(unitptr)lpPPrime,
							(unitptr)lpQPrime,DP,DQ,(unitptr)lpInvU);
	CountBBD(lpOutBuff,MAX_MOD_SLOP);

	RsaEnd:

	ResumeThread(hDCTThread);
	ResumeThread(hRBBThread);
	if (iResult < 0)
	{
		return(FALSE);
	}
	else
	{
		return(TRUE);
	}
}

// RsaPriDec decrypts a block of data equal to the size of Modulus
// n using your secret key. Exp e and Mod n not required because
// we use ModExpCrt.
//
// We only support the new conventional DEK packet format for
// PGP 2.3 and later.
//
// OutBuff must be MAX_MOD_SLOP in length.
//
// Entry: InBuff in Temp9.
//
// Uses: Temp1.
//
// Returns: Decrypted data in OutBuff and byte count in dwCountBytes.
//          Returns TRUE if we have an error, else FALSE.
//...................................................................
BOOL RsaPriDec(LPBYTE lpOutBuff, LPBYTE lpInBuff, LPBYTE lpDExp, LPBYTE lpPPrime, 
			   LPBYTE lpQPrime, LPBYTE lpInvU, DWORD dwModNBytes)
{
	BOOL	bError = FALSE;
	LPBYTE	lpTemp;
	int		iResult;
	unit	DP[MAX_UNIT_PRECISION]; 
	unit	DQ[MAX_UNIT_PRECISION];
	unit	temp[MAX_UNIT_PRECISION];

	SuspendThread(hRBBThread);
	SuspendThread(hDCTThread);

	set_precision(bytes2units(dwModNBytes+SLOP_BYTES));

	// Since we do not store these coefficents we have to compute
	// them here. DP = Exp d mod (p-1) and DQ = Exp d mod (q-1).
	//...........................................................
	mp_move(temp,(unitptr)lpPPrime);
	mp_dec(temp);
	mp_mod(DP,(unitptr)lpDExp,temp);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto PriDecEnd;
	}

	mp_move(temp,(unitptr)lpQPrime);
	mp_dec(temp);
	mp_mod(DQ,(unitptr)lpDExp,temp);

	// See if we want to quit.
	//........................
	CheckForMessages();
	if (bCancelOperation)
	{
		goto PriDecEnd;
	}
	// Decrypt the data using MpModExpCrt.
	//....................................
	iResult = mp_modexp_crt((unitptr)&Temp1,(unitptr)lpInBuff,(unitptr)lpPPrime,
							(unitptr)lpQPrime,DP,DQ,(unitptr)lpInvU);
	CircleSwap(&Temp1,dwModNBytes);

	if (iResult < 0)
	{
		goto PriDecEnd;
	}
	// Check out the decrypted data.
	//..............................
	__asm
	{
		mov		edi,offset Temp1
		cmp		byte ptr [edi],0
		je		L1
		mov		bError,TRUE
		jmp		PriDecEnd
	L1:	cmp		byte ptr [edi+1],CK_ENCRYPTED
		je		L2
		mov		bError,TRUE
		jmp		PriDecEnd
	L2:	add		edi,2

		// We have to get beyond our nozero random padding. The
		// first byte after the padding is a 0.
		//......................................................
		mov		al,0h
		mov		ecx,MAX_MOD_BYTES
		repne	scasb
		cmp		byte ptr [edi-1],0
		je		L3
		mov		bError,TRUE
		jmp		PriDecEnd

		// This byte must be equal to OTP_ALGORITHM.
		//..........................................
	L3:	cmp		byte ptr [edi],OTP_ALGORITHM
		je		L4
		mov		bError,TRUE
		jmp		PriDecEnd
	L4:	inc		edi

		// The number of bytes we need to transfer back is equal to
		// Mod n bytes minus (edi minus the offset of Temp1).
		//.........................................................
		mov		edx,edi
		sub		edx,offset Temp1
		mov		ecx,dwModNBytes
		sub		ecx,edx
		mov		dwCountBytes,ecx
		mov		lpTemp,edi
	}
	if (dwCountBytes < MAX_MOD_BYTES)
	{
		CopyMemory(lpOutBuff,lpTemp,dwCountBytes);
	}

	PriDecEnd:	

	ResumeThread(hDCTThread);
	ResumeThread(hRBBThread);
	return(bError);
}
